#include "sources/common.inc"

#define poe EXTERN
#include "sources/sys.inc"

#undef poe
#define poe PUBLIC
#include "sources/reader.inc"

; ix = this
read1:	ld a,(0)		; 3
	inc (ix + Reader__bufferPosition)	; 3
	ret nz		; 1
	jp Reader_Read__Continue		; 3
read2:

Reader__bufferPosition	equ Reader__bufferPositionMinus1 + 1

; hl = buffer start
; bc = buffer size
; ix = this
; ix <- this
; de <- this
Reader_Construct:
	ld a,l  ; check if buffer is 256-byte aligned
	or c
	call nz,SYS_ThrowException

	ld_de_ix

	push hl
	push de
	push bc
	ld hl,read1
	ld bc,read2-read1
	ldir
	pop bc
	pop de
	pop hl

	ld (ix + Reader__bufferStart),l
	ld (ix + Reader__bufferStart + 1),h
	ld (ix + Reader__bufferSize),c
	ld (ix + Reader__bufferSize + 1),b
	add hl,bc
	ld (ix + Reader__bufferEnd),l
	ld (ix + Reader__bufferEnd + 1),h
	dec hl  ; trap the next read
	ld (ix + Reader__bufferPosition),l
	ld (ix + Reader__bufferPosition + 1),h
	ld (ix + Reader__fillPending),-1
	ld_de_ix
	ret


; ix = this
; ix <- this
Reader_Destruct:
	ret

; ix = this
; a <- value
; Modifies: none
Reader_Read:
	jp (ix)
Reader_Read__Continue:
	push af
	ld a,(ix + Reader__bufferPosition + 1)
	inc a
	ld (ix + Reader__bufferPosition + 1),a
	cp (ix + Reader__bufferEnd + 1)
	jr z,Reader_Read__FinishBlock
	pop af
	ret
Reader_Read__FinishBlock:
	pop af
	bit 0,(ix + Reader__fillPending)
	jr nz,Reader_Read__PendingFill
	ld (ix + Reader__fillPending),-1
	ld (ix + Reader__bufferPosition),0FFH
	dec (ix + Reader__bufferPosition + 1)
	ret
Reader_Read__PendingFill:
	ld (ix + Reader__fillPending),0
	call Reader_FinishBlock
	jp (ix)

; ix = this
Reader_FinishBlock:
	ld a,(ix + Reader__bufferPosition)
	cp (ix + Reader__bufferEnd)
	call nz,SYS_ThrowException
	ld a,(ix + Reader__bufferPosition + 1)
	cp (ix + Reader__bufferEnd + 1)
	call nz,SYS_ThrowException
	push bc
	push de
	push hl
	call Reader_FillBuffer
	pop hl
	pop de
	pop bc
	ld a,(ix + Reader__bufferStart)
	ld (ix + Reader__bufferPosition),a
	ld a,(ix + Reader__bufferStart + 1)
	ld (ix + Reader__bufferPosition + 1),a
	ret

extern vReadCallBack

; ix = this
; Modifies: af, bc, de, hl
Reader_FillBuffer:
	exx
	push hl
	push de
	push bc
	exx
	call vReadCallBack
	exx
	pop bc
	pop de
	pop hl
	exx

	call SYS_ConsoleStatus  ; allow ctrl-c
	ld e,(ix + Reader__bufferStart)
	ld d,(ix + Reader__bufferStart + 1)
	ld l,(ix + Reader__bufferEnd)
	ld h,(ix + Reader__bufferEnd + 1)
	and a
	sbc hl,de
	ld b,(ix + Reader__fileHandle)
	call SYS_ReadFromFileHandle
	call SYS_CheckDOSError
	call SYS_ConsoleStatus  ; allow ctrl-c
	ret
; bc = nr of bytes to skip
; ix = this
; Modifies: bc, a
Reader_Skip:
	call Reader_Read
	dec bc
	ld a,b
	or c
	jr nz,Reader_Skip
	ret

; ix = this
; f <- c: bit
; Modifies: none
Reader_ReadBit:
	srl (ix + Reader__bits)
	ret nz  ; return if sentinel bit is still present
	push bc
	ld c,a
	call Reader_Read
	scf  ; set sentinel bit
	rra
	ld (ix + Reader__bits),a
	ld a,c
	pop bc
	ret

; c <- inline bit reader state
Reader_PrepareReadBitInline:
	ld c,(ix + Reader__bits)
	ret

; c = inline bit reader state
Reader_FinishReadBitInline:
	ld (ix + Reader__bits),c
	ret


; c <- inline bit reader state
; f <- c: bit
; Modifies: a
Reader_ReadBitInline_NextByte:
	call Reader_Read
	scf  ; set sentinel bit
	rra
	ld c,a
	ret

; c = inline bit reader state
; c <- inline bit reader state
; f <- c: bit
; Modifies: b
Reader_ReadBitInline_B MACRO
	srl c
	call z,Reader_ReadBitInline_B_NextByte  ; if sentinel bit is shifted out
	ENDM

; c <- inline bit reader state
; f <- c: bit
; Modifies: b
Reader_ReadBitInline_B_NextByte:
	ld b,a
	call Reader_Read
	scf  ; set sentinel bit
	rra
	ld c,a
	ld a,b
	ret

; c = inline bit reader state
; a <- value
; c <- inline bit reader state
; Modifies: b
Reader_ReadBitsInline_1:
	xor a
	Reader_ReadBitInline_B
	rla
	ret

Reader_ReadBitsInline_2:
	xor a
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rla
	rla
	ret

Reader_ReadBitsInline_3:
	xor a
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rla
	rla
	rla
	ret

Reader_ReadBitsInline_4:
	xor a
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rla
	rla
	rla
	rla
	ret

Reader_ReadBitsInline_5:
	xor a
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	rra
	rra
	rra
	ret

Reader_ReadBitsInline_6:	xor a
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	rra
	rra
	ret

Reader_ReadBitsInline_7:	xor a
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	rra
	ret

Reader_ReadBitsInline_8:	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	Reader_ReadBitInline_B
	rra
	ret

; b = nr of bits to read (1-8)
; ix = this
; a <- value
; Modifies: af, bc
Reader_ReadBits:	ld c,1
	xor a
Loop:
	call Reader_ReadBit
	jr nc,Zero
	add a,c
Zero:
	rlc c
	djnz Loop
	ret

; b = nr of bits to read (1-8)
; iy = this
; a <- value
; Modifies: af, bc
Reader_ReadBits_IY:	push iy
	ex (sp),ix
	call Reader_ReadBits
	pop ix
	ret

; ix = this
Reader_Align:	ld (ix + Reader__bits),0
	ret

end
