#include "sources/common.inc"

#define poe EXTERN
#include "sources/alphabet.inc"
#include "sources/reader.inc"
#include "sources/sys.inc"

#undef poe
#define poe PUBLIC
#include "sources/dalphabt.inc"

; hl = literal/length symbol handlers table
; de = distance symbol handlers table
; ix = this
; iy = reader
; ix <- this
; de <- this
DynamicAlphabets_Construct:
	push de
	push hl
	call DynamicAlphabets_ReadLengths
	call DynamicAlphabets_ReadHeaderCodeLengths
	push iy
	call DynamicAlphabets_ConstructHeaderCodeAlphabet
	pop iy
	call DynamicAlphabets_ReadLiteralLengthDistanceCodeLengths
	call DynamicAlphabets_DestructHeaderCodeAlphabet
	pop hl
	call DynamicAlphabets_ConstructLiteralLengthAlphabet
	pop hl
	call DynamicAlphabets_ConstructDistanceAlphabet
	ld_de_ix
	ret

; ix = this
DynamicAlphabets_ConstructHeaderCodeAlphabet:
	push ix
	ld hl,DynamicAlphabets__headerCodeLengths
	ld_de_ix
	add hl,de
	ld bc,DynamicAlphabets_MAX_HEADERCODELENGTHS
	call DynamicAlphabets_GetHeaderCodeAlphabet
	ex de,hl
	ld hl,DynamicAlphabets_headerCodeSymbols
	call Alphabet_Construct
	pop ix
	ret

; hl = literal/length symbol handlers table
; ix = this
DynamicAlphabets_ConstructLiteralLengthAlphabet:
	push ix
	push hl
	ld hl,DynamicAlphabets__literalLengthDistanceCodeLengths
	ld_de_ix
	add hl,de
	ld c,(ix + DynamicAlphabets__hlit)
	ld b,1
	call DynamicAlphabets_GetLiteralLengthAlphabet
	ex de,hl
	pop hl
	call Alphabet_Construct
	pop ix
	ret

; hl = distance symbol handlers table
; ix = this
DynamicAlphabets_ConstructDistanceAlphabet:
	push ix
	push hl
	ld hl,DynamicAlphabets__literalLengthDistanceCodeLengths
	ld_de_ix
	add hl,de
	ld e,(ix + DynamicAlphabets__hlit)
	ld d,1
	add hl,de
	ld c,(ix + DynamicAlphabets__hdist)
	ld b,0
	call DynamicAlphabets_GetDistanceAlphabet
	ex de,hl
	pop hl
	call Alphabet_Construct
	pop ix
	ret

; ix = this
; ix <- this
DynamicAlphabets_Destruct:
	push ix
	call DynamicAlphabets_GetLiteralLengthAlphabet
	call Alphabet_Destruct
	pop ix
	push ix
	call DynamicAlphabets_GetDistanceAlphabet
	call Alphabet_Destruct
	pop ix
	ret

; ix = this
DynamicAlphabets_DestructHeaderCodeAlphabet:
	push ix
	call DynamicAlphabets_GetHeaderCodeAlphabet
	call Alphabet_Destruct
	pop ix
	ret

; ix = this
DynamicAlphabets_GetHeaderCodeAlphabet:
	ld de,DynamicAlphabets__headerCodeAlphabet
	add ix,de
	ret

; ix = this
DynamicAlphabets_GetLiteralLengthAlphabet:
	ld de,DynamicAlphabets__literalLengthAlphabet
	add ix,de
	ret

; ix = this
DynamicAlphabets_GetDistanceAlphabet:
	ld de,DynamicAlphabets__distanceAlphabet
	add ix,de
	ret

; ix = this
; hl <- literal/length alphabet root
; de <- distance alphabet root
DynamicAlphabets_GetRoots:
	push ix
	call DynamicAlphabets_GetDistanceAlphabet
	ld e,(ix + Alphabet__root)
	ld d,(ix + Alphabet__root + 1)
	pop ix
	push de
	push ix
	call DynamicAlphabets_GetLiteralLengthAlphabet
	ld l,(ix + Alphabet__root)
	ld h,(ix + Alphabet__root + 1)
	pop ix
	pop de
	ret

; ix = this
; iy = reader
DynamicAlphabets_ReadLengths:
	ld b,5
	call Reader_ReadBits_IY
	inc a
dummy	equ LOW DynamicAlphabets_MAX_LITERALLENGTHCODELENGTHS
	cp dummy + 1
	call nc,SYS_ThrowException
	ld (ix + DynamicAlphabets__hlit),a
	ld b,5
	call Reader_ReadBits_IY
	inc a
	cp DynamicAlphabets_MAX_DISTANCECODELENGTHS + 1
	call nc,SYS_ThrowException
	ld (ix + DynamicAlphabets__hdist),a
	ld b,4
	call Reader_ReadBits_IY
	add a,4
	cp DynamicAlphabets_MAX_HEADERCODELENGTHS + 1
	call nc,SYS_ThrowException
	ld (ix + DynamicAlphabets__hclen),a
	ret

; ix = this
; iy = reader
DynamicAlphabets_ReadHeaderCodeLengths:
	ld b,(ix + DynamicAlphabets__hclen)
	ld hl,DynamicAlphabets_headerCodeOrder
Loop:
	ld e,(hl)
	ld d,0
	inc hl
	push hl
	push ix
	add ix,de
	push bc
	ld b,3
	call Reader_ReadBits_IY
	pop bc
	ld (ix + DynamicAlphabets__headerCodeLengths),a
	pop ix
	pop hl
	djnz Loop
	ret

; ix = this
; iy = reader
DynamicAlphabets_ReadLiteralLengthDistanceCodeLengths:
	ld hl,DynamicAlphabets__literalLengthDistanceCodeLengths
	ld_de_ix
	add hl,de
	ld a,(ix + DynamicAlphabets__hlit)
	add a,(ix + DynamicAlphabets__hdist)
	push ix
	call DynamicAlphabets_GetHeaderCodeAlphabet
	call Alphabet_GetRoot
	ld e,a
	ld d,2  ; +1 for nested 8-bit loop
	push ix
	ex (sp),iy
	pop ix
	call Reader_PrepareReadBitInline
	call DynamicAlphabets_DecodeLiteralLengthDistanceCodeLengths
	call Reader_FinishReadBitInline
	pop ix
	ret

; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_DecodeLiteralLengthDistanceCodeLengths:
	jp (iy)

; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_WriteAndNext:
	inc hl
	dec e
	jp nz,DynamicAlphabets_DecodeLiteralLengthDistanceCodeLengths
	dec d
	jr nz,DynamicAlphabets_DecodeLiteralLengthDistanceCodeLengths
	ret

; a = fill value
; b = repeat count
; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_FillAndNext_Loop:
	dec b
	jr z,DynamicAlphabets_DecodeLiteralLengthDistanceCodeLengths
DynamicAlphabets_FillAndNext:
	ld (hl),a
	inc hl
	dec e
	jp nz,DynamicAlphabets_FillAndNext_Loop
	dec d
	jr nz,DynamicAlphabets_FillAndNext_Loop
	ret

; Header code alphabet symbols 0-15
; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_WriteLength:
dasize	equ	5
value	defl	0
	REPT 16
	ld (hl),value
value	defl	value+1
	jp DynamicAlphabets_WriteAndNext
	ENDR

; Header code alphabet symbols 16
; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_Copy:
	call Reader_ReadBitsInline_2
	add a,3
	ld b,a
	dec hl
	ld a,(hl)
	inc hl
	jp DynamicAlphabets_FillAndNext

; Header code alphabet symbols 17
; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_FillZero_3:
	call Reader_ReadBitsInline_3
	add a,3
	ld b,a
	xor a
	jp DynamicAlphabets_FillAndNext

; Header code alphabet symbols 18
; c = inline bit reader state
; de = loop counter for nested 8-bit loop
; hl = literal/length/distance code lengths position
; ix = reader
; iy = header code alphabet root
DynamicAlphabets_FillZero_11:
	call Reader_ReadBitsInline_7
	add a,11
	ld b,a
	xor a
	jp DynamicAlphabets_FillAndNext

	rseg data

DynamicAlphabets_headerCodeOrder:
	defb 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15

DynamicAlphabets_headerCodeSymbols:
	defw  DynamicAlphabets_WriteLength + dasize*0, DynamicAlphabets_WriteLength + dasize*1, DynamicAlphabets_WriteLength + dasize*2, DynamicAlphabets_WriteLength + dasize*3
	defw  DynamicAlphabets_WriteLength + dasize*4, DynamicAlphabets_WriteLength + dasize*5, DynamicAlphabets_WriteLength + dasize*6, DynamicAlphabets_WriteLength + dasize*7
	defw  DynamicAlphabets_WriteLength + dasize*8, DynamicAlphabets_WriteLength + dasize*9, DynamicAlphabets_WriteLength + dasize*10, DynamicAlphabets_WriteLength + dasize*11
	defw  DynamicAlphabets_WriteLength + dasize*12, DynamicAlphabets_WriteLength + dasize*13, DynamicAlphabets_WriteLength + dasize*14, DynamicAlphabets_WriteLength + dasize*15
	defw  DynamicAlphabets_Copy, DynamicAlphabets_FillZero_3, DynamicAlphabets_FillZero_11, SYS_ThrowException

end
