#include "sources/common.inc"

#define poe EXTERN
#include "sources/branch.inc"
#include "sources/sys.inc"

#undef poe
#define poe PUBLIC
#include "sources/alphabet.inc"

	EXTERN free, malloc

; bc = code length table length
; de = code length table
; hl = symbol handler table
; ix = this
; ix <- this
; de <- this
Alphabet_Construct:
	ld a,b
	or c
	call z,SYS_ThrowException
	ld (ix + Alphabet__Process),0xC3	; JP
	ld (ix + Alphabet__codeLengthCount),c
	ld (ix + Alphabet__codeLengthCount + 1),b
	ld (ix + Alphabet__codeLengths),e
	ld (ix + Alphabet__codeLengths + 1),d
	ld (ix + Alphabet__symbolHandlers),l
	ld (ix + Alphabet__symbolHandlers + 1),h
	call Alphabet_AllocateTreeBuffer
	call Alphabet_SortCodeLengths
	call Alphabet_BuildTree
	ld_de_ix
	ret

; ix = this
; ix <- this
Alphabet_Destruct:
	ld e,(ix + Alphabet__treeStart)
	ld d,(ix + Alphabet__treeStart + 1)
	;ld c,(ix + Alphabet__treeSize)
	;ld b,(ix + Alphabet__treeSize + 1)
	push ix
	call free
	pop ix
	ret

; ix = this
; ix <- root branch
; de <- root branch
Alphabet_GetRoot:
	ld e,(ix + Alphabet__root)
	ld d,(ix + Alphabet__root + 1)
	ld_ix_de
	ret

; ix = this
Alphabet_Process:
	jp (ix)

; iy = this
Alphabet_Process_IY:
	jp (iy)

; Modifies: af, bc, de, hl
Alphabet_AllocateTreeBuffer:
	call Alphabet_CalculateTreeBufferSize
	ld (ix + Alphabet__treeSize),l
	ld (ix + Alphabet__treeSize + 1),h

	push hl
	ld e,l
	ld d,h

	push ix
	call malloc
	ex de,hl
	pop ix

	ld (ix + Alphabet__treeStart),e
	ld (ix + Alphabet__treeStart + 1),d
	pop hl

	add hl,de
	ld (ix + Alphabet__treeEnd),l
	ld (ix + Alphabet__treeEnd + 1),h
	ret

; hl <- buffer size
; Modifies: af
Alphabet_CalculateTreeBufferSize:
	ld c,(ix + Alphabet__codeLengthCount)
	ld b,(ix + Alphabet__codeLengthCount + 1)
	ld a,Branch___size + Alphabet_LEAF_SIZE
	ld hl,0
Alphabet_CalculateTreeBufferSize__Loop:
	add hl,bc
	dec a
	jp nz,Alphabet_CalculateTreeBufferSize__Loop
	ret

; Generate list of (code length, symbol) pairs, sorted by code length
; ix = this
Alphabet_SortCodeLengths:
	call Alphabet_InitCodeLengthsTable
	exx
	ld l,(ix + Alphabet__symbolHandlers)
	ld h,(ix + Alphabet__symbolHandlers + 1)
	exx
	ld l,(ix + Alphabet__codeLengths)
	ld h,(ix + Alphabet__codeLengths + 1)
	ld e,(ix + Alphabet__codeLengthCount)
	ld d,(ix + Alphabet__codeLengthCount + 1)
	ld b,e  ; convert 16-bit counter de to two 8-bit counters in b and c
	dec de
	inc d
	ld c,d
Alphabet_SortCodeLengths__Loop:
	ld a,(hl)
	inc hl
	add a,a
	jr z,Alphabet_SortCodeLengths__Skip
	exx
	ld e,a
	ld d,0
	push ix
	add ix,de
	ld e,(ix + Alphabet__codeLengthCounts - 2)
	ld d,(ix + Alphabet__codeLengthCounts - 1)
	rrca
	ld (de),a
	inc de
	ldi
	ldi
	ld (ix + Alphabet__codeLengthCounts - 2),e
	ld (ix + Alphabet__codeLengthCounts - 1),d
	pop ix
	exx
Alphabet_SortCodeLengths__SkipContinue:
	djnz Alphabet_SortCodeLengths__Loop
	dec c
	jr nz,Alphabet_SortCodeLengths__Loop
	ret
Alphabet_SortCodeLengths__Skip:
	exx
	inc hl
	inc hl
	exx
	jp Alphabet_SortCodeLengths__SkipContinue

; ix = this
Alphabet_InitCodeLengthsTable:
	call Alphabet_CountCodeLengths
	call Alphabet_GetSortedCodeLengthsStart
	ld (ix + Alphabet__sortedCodeLengths),l
	ld (ix + Alphabet__sortedCodeLengths + 1),h
	ld b,Alphabet_MAX_CODELENGTH
	push ix
Alphabet_InitCodeLengthsTable__Loop:
	ld e,(ix + Alphabet__codeLengthCounts)
	ld d,(ix + Alphabet__codeLengthCounts + 1)
	ld (ix + Alphabet__codeLengthCounts),l
	ld (ix + Alphabet__codeLengthCounts + 1),h
	inc ix
	inc ix
	add hl,de
	add hl,de
	add hl,de
	djnz Alphabet_InitCodeLengthsTable__Loop
	ld (hl),-1
	pop ix
	ret

; ix = this
; hl <- sorted code lengths start address
Alphabet_GetSortedCodeLengthsStart:
	ld e,(ix + Alphabet__codeLengthCount)
	ld d,(ix + Alphabet__codeLengthCount + 1)
	ld l,e
	ld h,d
	add hl,hl
	add hl,de  ; x3
	ex de,hl
	ld l,(ix + Alphabet__treeEnd)
	ld h,(ix + Alphabet__treeEnd + 1)
	scf        ; +1 extra for sentinel byte
	sbc hl,de
	ret

; ix = this
Alphabet_CountCodeLengths:
	ld e,(ix + Alphabet__codeLengthCount)
	ld d,(ix + Alphabet__codeLengthCount + 1)
	ld l,(ix + Alphabet__codeLengths)
	ld h,(ix + Alphabet__codeLengths + 1)
	ld b,e  ; convert 16-bit counter de to two 8-bit counters in b and c
	dec de
	inc d
	ld c,d
	exx
	ld_de_ix
	ld hl,Alphabet__codeLengthCounts - 2
	add hl,de
	ex de,hl
	exx
Alphabet_CountCodeLengths__Loop:
	ld a,(hl)
	inc hl
	and a
	jr z,Alphabet_CountCodeLengths__Skip
	cp Alphabet_MAX_CODELENGTH + 1
	call nc,SYS_ThrowException
	exx
	add a,a
	ld l,a
	ld h,0
	add hl,de
	inc (hl)
	jr z,Alphabet_CountCodeLengths__Overflow
Alphabet_CountCodeLengths__OverflowContinue:
	exx
Alphabet_CountCodeLengths__Skip:
	djnz Alphabet_CountCodeLengths__Loop
	dec c
	jr nz,Alphabet_CountCodeLengths__Loop
	ret
Alphabet_CountCodeLengths__Overflow:
	inc hl
	inc (hl)
	jp Alphabet_CountCodeLengths__OverflowContinue

; ix = this
Alphabet_BuildTree:
	call Alphabet_GetFirstSymbol
	jp c,Alphabet_BuildTree__TrapEmptyTree
	ld e,(ix + Alphabet__treeStart)
	ld d,(ix + Alphabet__treeStart + 1)
	ld (ix + Alphabet__root),e
	ld (ix + Alphabet__root + 1),d
	call Alphabet_BuildBranch
	ld l,(ix + Alphabet__treeEnd)
	ld h,(ix + Alphabet__treeEnd + 1)
	and a
	sbc hl,de
	call c,SYS_ThrowException
	ret
Alphabet_BuildTree__TrapEmptyTree:
	ld (ix + Alphabet__root),LOW SYS_ThrowException
	ld (ix + Alphabet__root + 1),HIGH SYS_ThrowException
	ret

; b = bits left
; c = code length
; de = tree position
; hl = sorted (code length, symbol) list pointer
; iy = current branch
; ix = this
Alphabet_BuildBranch:
	push iy
	call Alphabet_AddBranch
	call Alphabet_BuildBranchZero
	call nc,Alphabet_BuildBranchOne
	pop iy
	ret

; b = bits left
; c = code length
; de = tree position
; hl = sorted (code length, symbol) list pointer
; iy = current branch
; ix = this
Alphabet_BuildBranchZero:
	djnz Alphabet_BuildBranchOne__Branch
Alphabet_BuildBranchZero__Leaf:
	call Alphabet_AddLeaf
	call Alphabet_GetNextSymbol
	inc b
	ret
Alphabet_BuildBranchZero__Branch:
	call Alphabet_BuildBranch
	inc b
	ret

; b = bits left
; c = code length
; de = tree position
; hl = sorted (code length, symbol) list pointer
; iy = current branch
; ix = this
Alphabet_BuildBranchOne:
	djnz Alphabet_BuildBranchOne__Branch
Alphabet_BuildBranchOne__Leaf:
	ld a,(hl)
	inc hl
	ld (iy + Branch__jumpAddress),a
	ld a,(hl)
	inc hl
	ld (iy + Branch__jumpAddress + 1),a
	call Alphabet_GetNextSymbol
	inc b
	ret
Alphabet_BuildBranchOne__Branch:
	ld (iy + Branch__jumpAddress),e
	ld (iy + Branch__jumpAddress + 1),d
	call Alphabet_BuildBranch
	inc b
	ret

; b = bits left
; c = code length
; hl = sorted (code length, symbol) list pointer
; ix = this
; b, c, hl <- updated
; f <- c: end reached
Alphabet_GetNextSymbol:
Alphabet_GetNextSymbol__NextLengthLoop:
	ld a,(hl)
	cp c
	jr nz,Alphabet_GetNextSymbol__NextLength
	inc hl
	ret
Alphabet_GetNextSymbol__NextLength:
	ret m
	inc b
	inc c
	jp Alphabet_GetNextSymbol__NextLengthLoop

; ix = this
; b <- bits left
; c <- code length
; hl <- sorted (code length, symbol) list pointer
; f <- c: end reached
Alphabet_GetFirstSymbol:
	ld l,(ix + Alphabet__sortedCodeLengths)
	ld h,(ix + Alphabet__sortedCodeLengths + 1)
	ld bc,0
	jp Alphabet_GetNextSymbol

; ix = this
; de = tree position
; de <- updated tree position
; iy <- branch
; Modifies: f
Alphabet_AddBranch:
	push bc
	push hl
	ld_iy_de
	ld hl,Branch_template
	ld bc,Branch___size
	ldir
	pop hl
	pop bc
	ret

; ix = this
; de = tree position
; hl = sorted (code length, symbol) list pointer
; de <- updated tree position
; Modifies: hl
Alphabet_AddLeaf:
	ld a,0xC3	; JP
	ld (de),a
	inc de
	push bc
	ldi
	ldi
	pop bc
	ret

end
