#define _USE_MATH_DEFINES
#include <math.h>
#include <stdlib.h>

#include "FrequencyDetector.h"

/*
 =======================================================================================================================
 =======================================================================================================================
 */
FrequencyDetector::FrequencyDetector(int _iSamplingFrequency, double _fFrequencyToDetect, int _iSamplesCount)
{

	m_iSamplingFrequency = _iSamplingFrequency;

	m_iSamplesCount = _iSamplesCount;
	m_afSamples = (double *) malloc(m_iSamplesCount * sizeof(double));

	vSetFrequencyToDetect(_fFrequencyToDetect);
	vReset();
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void FrequencyDetector::vReset()
{
	/*~~~~~~~*/
	int iIndex;
	/*~~~~~~~*/

	m_iCurrentSample = 0;
	m_fSampleSum = 0.0;

	for(iIndex = 0; iIndex < m_iSamplesCount; iIndex++)
	{
		m_afSamples[iIndex] = 0.0;
	}
}


/*
 =======================================================================================================================
 =======================================================================================================================
 */
FrequencyDetector::~FrequencyDetector()
{
	free(m_afSamples);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void FrequencyDetector::vSetFrequencyToDetect(double _fFrequencyToDetect)
{
	m_fFrequencyToDetect = _fFrequencyToDetect;
	m_fCoeff = 2.0 * cos(2.0 * M_PI * m_fFrequencyToDetect / (double) m_iSamplingFrequency);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
double FrequencyDetector::fPower(bool _bNormalize)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	double	fPrevious;
	double	fPreviousPrevious;
	int		iSampleCount, iSampleIndex;
	double	fResult;
	double fAverage;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	fAverage = m_fSampleSum / (double)m_iSamplesCount;

	fPrevious = 0.0;
	fPreviousPrevious = 0.0;
	iSampleIndex = m_iCurrentSample;
	for(iSampleCount = 0; iSampleCount < m_iSamplesCount; iSampleCount++)
	{
		/*~~~~~~*/
		double	fS;
		/*~~~~~~*/

		fS = m_afSamples[iSampleIndex];
		if(_bNormalize)
		{
			fS -= fAverage;
		}
		fS += m_fCoeff * fPrevious - fPreviousPrevious;
		iSampleIndex++;
		if(iSampleIndex >= m_iSamplesCount)
		{
			iSampleIndex = 0;
		}

		fPreviousPrevious = fPrevious;
		fPrevious = fS;
	}

	fResult = fPreviousPrevious * fPreviousPrevious + fPrevious * fPrevious - m_fCoeff * fPrevious * fPreviousPrevious;
	return fResult / (double)m_iSamplesCount;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void FrequencyDetector::vUpdate(double _fSample)
{
	m_fSampleSum -= m_afSamples[m_iCurrentSample];
	m_afSamples[m_iCurrentSample] = _fSample;
	m_fSampleSum += _fSample;
	m_iCurrentSample++;
	if(m_iCurrentSample >= m_iSamplesCount)
	{
		m_iCurrentSample = 0;
	}
}
