#include "AudioInput.h"
#include "FrequencyDetector.h"

typedef enum
{
	BIT_0,
	BIT_1,
	BIT_SILENCE,
	BIT_EOF
}
	tdBit;

class BitReader
{
public:
	BitReader(AudioInput *_poAudioInput, double _fHeaderFrequency, double _fPhaseAdjustCoeff, double _fSilenceRatio, double _fHeaderEndSensitivity);
	~BitReader();

	bool bReadNextBit(tdBit * _peBit);

	double m_fPhase;
	double m_fPeriod;
	double m_fBitPeriod;
	double m_fBaudRate;
	double m_fSilenceRatio;

	bool m_bCurrentBit;
	bool m_bPreviousBit;
	bool m_bPhaseDefined;

	double m_fLast1200Power;
	double m_fLast2400Power;
	double m_fPhaseAdjustCoeff;
	double m_fHeaderEndSensitivity;

	FrequencyDetector	*m_poFD1200;
	FrequencyDetector	*m_poFD2400;

	AudioInput * m_poAudioInput;
};
