#ifndef AudioInput_h
#define AudioInput_h

#include <windows.h>
#include <dsound.h>
#include <stdio.h>

typedef short int	RecAudioSample;

class				AudioInput
{
/*
 -----------------------------------------------------------------------------------------------------------------------
 -----------------------------------------------------------------------------------------------------------------------
 */
public:
	AudioInput(unsigned int _uiFrequency, double _fVolume, double _fBufferLength, int _iInputDevice);
	AudioInput(FILE * _poWavFile, double _fVolume);
	~			AudioInput();
	static void vListAudioDevices();
	int			iFrequency();
	void		vStop();
	void		vRecord();
	bool		bRead(double *_pfSample);

	double		m_fMaxAmplitude;
	double		m_fTime;

/*
 -----------------------------------------------------------------------------------------------------------------------
 -----------------------------------------------------------------------------------------------------------------------
 */
private:

	FILE * m_poWavFile;
	int m_iBytesPerBloc;
	unsigned char *m_pcBloc;
	int m_iBitsPerSample;

	LPDIRECTSOUNDCAPTURE		m_poDirectSound;
	LPDIRECTSOUNDCAPTUREBUFFER	m_poCaptureBuffer;
	int							m_iFrequency;
	double						m_fVolumeAmplification;

	/* Positions and sizes below are expressed in bytes */
	RecAudioSample				*m_piHWBuffer;
	int							m_iHWBufferSize;
	int							m_iHWBytesAvailable;
	int							m_iHWPreviousBytesAvailable;
	int							m_iHWPosition;

	char						*m_pcSWBuffer;
	int							m_iSWBufferSize;
	int							m_iSWPosition;

	int							m_iHead;

	bool						m_bDeviceFound;
	int							m_iDesiredDeviceIndex;
	LPGUID						m_poDesiredDeviceGUID;
	static BOOL CALLBACK		bEnumerateCallback
								(
									LPGUID	lpGUID,
									LPCTSTR lpszDesc,
									LPCTSTR lpszDrvName,
									LPVOID	lpContext
								);
};
#endif
