;******************************************************************************
;**             MSX-DOS (DiskROM) System Variables located in RAM            **
;******************************************************************************

;These addresses are only initialized when a DiskROM is present (e.g. 
;when the machine has a diskdrive or a harddisk interface connected).


RAMAD0 equ 0xF341
;  Length: 1
;  Slot address of RAM in page 0 (DOS)


RAMAD1 equ 0xF342
;  Length: 1
;  Slot address of RAM in page 1 (DOS)


RAMAD2 equ 0xF343
;  Length: 1
;  Slot address of RAM in page 2 (DOS/BASIC)


RAMAD3 equ 0xF344
;  Length: 1
;  Slot address of RAM in page 3 (DOS/BASIC)

DSKSLT equ 0xF348
;  Length: 1
;  Slot address of the main DiskROM




;******************************************************************************
;**                   MSX System Variables located in RAM                    **
;******************************************************************************

;This is the start of the MSX BIOS system area.


RDPRIM equ 0xF380
;  Length: 5
;  Routine that reads from a primary slot


WRPRIM equ 0xF385
;  Length: 7
;  Routine that writes to a primary slot


CLPRIM equ 0xF38C
;  Length: 4
;  Routine that calls a routine in a primary slot


USRTAB equ 0xF39A
;  Length: 2
;  Address to call with Basic USR0


;  0xF39C
;  Length: 2
;  Address to call with Basic USR1


;  0xF39E
;  Length: 2
;  Address to call with Basic USR2


;  0xF3A0
;  Length: 2
;  Address to call with Basic USR3


;  0xF3A2
;  Length: 2
;  Address to call with Basic USR4


;  0xF3A4
;  Length: 2
;  Address to call with Basic USR5


;  0xF3A6
;  Length: 2
;  Address to call with Basic USR6


;  0xF3A8
;  Length: 2
;  Address to call with Basic USR7


;  0xF3AA
;  Length: 2
;  Address to call with Basic USR8


;  0xF3AC
;  Length: 2
;  Address to call with Basic USR9


LINL40 equ 0xF3AE
;  Length: 1
;  Width for SCREEN 0 (default 37)


LINL32 equ 0xF3AF
;  Length: 1
;  Width for SCREEN 1 (default 29)


LINLEN equ 0xF3B0
;  Length: 1
;  Width for the current text mode


CRTCNT equ 0xF3B1
;  Length: 1
;  Number of lines on screen


CLMLST equ 0xF3B2
;  Length: 1
;  Column space. Its uncertain what this address actually stores


TXTNAM equ 0xF3B3
;  Length: 2
;  BASE(0) - SCREEN 0 name table


TXTCOL equ 0xF3B5
;  Length: 2
;  BASE(1) - SCREEN 0 color table


TXTCGP equ 0xF3B7
;  Length: 2
;  BASE(2) - SCREEN 0 character pattern table


TXTATR equ 0xF3B9
;  Length: 2
;  BASE(3) - SCREEN 0 Sprite Attribute Table


TXTPAT equ 0xF3BB
;  Length: 2
;  BASE(4) - SCREEN 0 Sprite Pattern Table


T32NAM equ 0xF3B3
;  Length: 2
;  BASE(5) - SCREEN 1 name table


T32COL equ 0xF3B5
;  Length: 2
;  BASE(6) - SCREEN 1 color table


T32CGP equ 0xF3B7
;  Length: 2
;  BASE(7) - SCREEN 1 character pattern table


T32ATR equ 0xF3B9
;  Length: 2
;  BASE(8) - SCREEN 1 sprite attribute table


T32PAT equ 0xF3BB
;  Length: 2
;  BASE(9) - SCREEN 1 sprite pattern table


GRPNAM equ 0xF3B3
;  Length: 2
;  BASE(10) - SCREEN 2 name table


GRPCOL equ 0xF3B5
;  Length: 2
;  BASE(11) - SCREEN 2 color table


GRPCGP equ 0xF3B7
;  Length: 2
;  BASE(12) - SCREEN 2 character pattern table


GRPATR equ 0xF3B9
;  Length: 2
;  BASE(13) - SCREEN 2 sprite attribute table


GRPPAT equ 0xF3BB
;  Length: 2
;  BASE(14) - SCREEN 2 sprite pattern table


MLTNAM equ 0xF3B3
;  Length: 2
;  BASE(15) - SCREEN 3 name table


MLTCOL equ 0xF3B5
;  Length: 2
;  BASE(16) - SCREEN 3 color table


MLTCGP equ 0xF3B7
;  Length: 2
;  BASE(17) - SCREEN 3 character pattern table


MLTATR equ 0xF3B9
;  Length: 2
;  BASE(18) - SCREEN 3 sprite attribute table


MLTPAT equ 0xF3BB
;  Length: 2
;  BASE(19) - SCREEN 3 sprite pattern table


CLIKSW equ 0xF3DB
;  Length: 1
;  =0 when key press click disabled
;  =1 when key press click enabled
;  SCREEN ,,n will write to this address


CSRY equ 0xF3DC
;  Length: 1
;  Current row-position of the cursor


CSRX equ 0xF3DD
;  Length: 1
;  Current column-position of the cursor


CNSDFG equ 0xF3DE
;  Length: 1
;  =0 when function keys are not displayed
;  =1 when function keys are displayed


RG0SAV equ 0xF3DF
;  Length: 1
;  Content of VDP(0) register (R#0)


RG1SAV equ 0xF3E0
;  Length: 1
;  Content of VDP(1) register (R#1)


RG2SAV equ 0xF3E1
;  Length: 1
;  Content of VDP(2) register (R#2)


RG3SAV equ 0xF3E2
;  Length: 1
;  Content of VDP(3) register (R#3)


RG4SAV equ 0xF3E3
;  Length: 1
;  Content of VDP(4) register (R#4)


RG5SAV equ 0xF3E4
;  Length: 1
;  Content of VDP(5) register (R#5)


RG6SAV equ 0xF3E5
;  Length: 1
;  Content of VDP(6) register (R#6)


RG7SAV equ 0xF3E6
;  Length: 1
;  Content of VDP(7) register (R#7)


STATFL equ 0xF3E7
;  Length: 1
;  Content of VDP(8) status register (S#0)


TRGFLG equ 0xF3E8
;  Length: 1
;  Information about trigger buttons and space bar state
;7 6 5 4 3 2 1 0
;| | | |       +-- Space bar, trig(0) (0 = pressed)
;| | | +---------- Stick 1, Trigger 1 (0 = pressed)
;| | +------------ Stick 1, Trigger 2 (0 = pressed)
;| +-------------- Stick 2, Trigger 1 (0 = pressed)
;+---------------- Stick 2, Trigger 2 (0 = pressed)


FORCLR equ 0xF3E9
;  Length: 1
;  Foreground color


BAKCLR equ 0xF3EA
;  Length: 1
;  Background color


BDRCLR equ 0xF3EB
;  Length: 1
;  Border color


MAXUPD equ 0xF3EC
;  Length: 3
;  Jump instruction used by Basic LINE command. The routines used are:
;      RIGHTC,
;      LEFTC,
;      UPC and
;      DOWNC


MINUPD equ 0xF3EF
;  Length: 3
;  Jump instruction used by Basic LINE command. The routines used are:
;      RIGHTC,
;      LEFTC,
;      UPC and
;      DOWNC


ATRBYT equ 0xF3F2
;  Length: 1
;  Attribute byte (for graphical routines its used to read the color)


QUEUES equ 0xF3F3
;  Length: 2
;  Address of the queue table


FRCNEW equ 0xF3F5
;  Length: 1
;  CLOAD flag
;      =0 when CLOAD
;      =255 when CLOAD?


SCNCNT equ 0xF3F6
;  Length: 1
;  Key scan timing
;      When its zero, the key scan routine will scan for pressed keys so
;      characters can be written to the keyboard buffer


REPCNT equ 0xF3F7
;  Length: 1
;  This is the key repeat delay counter

;      When it reaches zero, the key will repeat


PUTPNT equ 0xF3F8
;  Length: 2
;  Address in the keyboard buffer where a character will be written


GETPNT equ 0xF3FA
;  Length: 2
;  Address in the keyboard buffer where the next character is read


CS120 equ 0xF3FC
;  Length: 5
;  Cassette I/O parameters to use for 1200 baud


CS240 equ 0xF401
;  Length: 5
;  Cassette I/O parameters to use for 2400 baud


TLOW equ 0xF406
;  Length: 2
;  Signal delay when writing a 0 to tape


THIGH equ 0xF408
;  Length: 2
;  Signal delay when writing a 1 to tape


HEADER equ 0xF40A
;  Length: 1
;  Delay of tape header (sync.) block


ASPCT1 equ 0xF40B
;  Length: 2
;  Horizontal / Vertical aspect for CIRCLE command


ASPCT2 equ 0xF40D
;  Length: 2
;  Horizontal / Vertical aspect for CIRCLE command


ENDPRG equ 0xF40F
;  Length: 5
;  Pointer for the RESUME NEXT command


ERRFLG equ 0xF414
;  Length: 1
;  Basic Error code


LPTPOS equ 0xF415
;  Length: 1
;  Position of the printer head
;      Is read by Basic function LPOS and used by LPRINT Basic command


PRTFLG equ 0xF416
;  Length: 1
;  Printer output flag is read by
;      OUTDO
;      =0 to print to screen
;      =1 to print to printer


NTMSXP equ 0xF417
;  Length: 1
;  Printer type is read by
;      OUTDO.
;      SCREEN ,,,n writes to this address
;      =0 for MSX printer
;      =1 for non-MSX printer


RAWPRT equ 0xF418
;  Length: 1
;  Raw printer output is read by
;     OUTDO
;      =0 to convert tabs and unknown characters to spaces and
;         remove graphical headers
;      =1 to send data just like it gets it


VLZADR equ 0xF419
;  Length: 2
;  Address of data that is temporarilly replaced by O when Basic
;      function VAL("") is running


VLZDAT equ 0xF41B
;  Length: 1
;  Original value that was in the address pointed to with
;      VLZADR


CURLIN equ 0xF41C
;  Length: 2
;  Line number the Basic interpreter is working on, in direct mode
;      it will be filled with 0xFFFF


;  0xF91F
;  Length: 1
;  Character set SlotID


;  0xF920
;  Length: 2
;  Character set address


EXBRSA equ 0xFAF8
;  Length: 1
;  Slot address of the SUBROM (EXtended Bios-Rom Slot Address)


DRVINF equ 0xFB21
;  Length: 1
;  Nr. of drives connected to disk interface 1


;  0xFB22
;  Length: 1
;  Slot address of disk interface 1


;  0xFB23
;  Length: 1
;  Nr. of drives connected to disk interface 2


;  0xFB24
;  Length: 1
;  Slot address of disk interface 2


;  0xFB25
;  Length: 1
;  Nr. of drives connected to disk interface 3


;  0xFB26
;  Length: 1
;  Slot address of disk interface 3


;  0xFB27
;  Length: 1
;  Nr. of drives connected to disk interface 4


;  0xFB28
;  Length: 1
;  Slot address of disk interface 4


EXPTBL equ 0xFCC1
;  Length: 1
;  Slot 0: 0x80 = expanded, 0 = not expanded. Also slot address of the main BIOS-ROM.


;  0xFCC2
;  Length: 1
;  Slot 1: 0x80 = expanded, 0 = not expanded.


;  0xFCC3
;  Length: 1
;  Slot 2: 0x80 = expanded, 0 = not expanded.


;  0xFCC4
;  Length: 1
;  Slot 3: 0x80 = expanded, 0 = not expanded.


SLTTBL equ 0xFCC5
;  Length: 1
;  Mirror of slot 0 secondary slot selection register.


;  0xFCC6
;  Length: 1
;  Mirror of slot 1 secondary slot selection register.


;  0xFCC7
;  Length: 1
;  Mirror of slot 2 secondary slot selection register.


;  0xFCC8
;  Length: 1
;  Mirror of slot 3 secondary slot selection register.


;  0xFFFF (all slots)
;  Length: 1
;  Secondary slot select register. Reading returns the inverted previously written value.

BOTTOM	EQU	0xFC48
HIMEM	EQU	0xFC4A
SLTWRK	EQU	0xFD09
