; Laser Squad disk launcher 1.2
; Copyright (c) 2016 Laurent Halter
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted FOR NON COMMERCIAL USAGE, provided that the following conditions
; are met:
; 
; 1. Redistributions of source code must retain the above copyright notice, this
;    list of conditions and the following disclaimer.
;
; 2. Redistributions in binary form must reproduce the above copyright notice,
;    this list of conditions and the following disclaimer in the documentation
;    and/or other materials provided with the distribution.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*include msxvars.inc
*include msxbios.inc
*include msxhooks.inc

swapAreaStart	equ	0xC000 + buffer
scenarioLoadingAddress	equ	0xB621

;***********************************************************
;***********************************************************

MSXDOS	equ	0x0005

FCB_DR	equ	0
FCB_FNAME	equ	1
FCB_FEXT	equ	9
FCB_EX	equ	12
FCB_S1	equ	13
FCB_RECSIZ	equ	14
FCB_FILSIZ	equ	16
FCB_DATE	equ	20
FCB_TIME	equ	22
FCB_DEVID	equ	24
FCB_DIRLOC	equ	25
FCB_STRCLS	equ	26
FCB_CURCLS	equ	28
FCB_CLSOFF	equ	30
FCB_CN	equ	32
FCB_RN	equ	33
FCB_SIZE	equ	37

;***********************************************************

VDPPORT0	equ	0x98
VDPPORT1	equ	0x99

;***********************************************************
;***********************************************************
	psect	text
;***********************************************************
;***********************************************************

_main::	ld	a,(0xFFE8)
	ld	(reg9),a

	ld	hl,titleFileNameMSX1
	call	isMSX1
	jr	z,1f
	ld	hl,titleFileNameMSX2
1:	ld	(selectedTitle),hl


	call	parseArguments

	ld	a,(reg9)
	ld	(0xFFE8),a

	ld	hl,(selectedPalet)
	ld	a,h
	or	l
	call	nz,setPalet

	ld	hl,(selectedTitle)
	call	title

	ei
	call	waitForKey
	
	ld	a,2
	call	screen

	ld	hl,loaderFileName
	call	fopen

	ld	hl,TZXHeaderSize
	call	fseek

	ld	de,0x4000
	ld	hl,0xFFFF
	call	fread

	call	fclose
	call	stopDisk
	
	ld	hl,gamePatch
	call	applyPatch

	di
	ld	(DOSStack),sp
	ld	sp,000FEH
	call	swap
	jp	0x4000

;***********************************************************

loaderFileName:	defb	0,"GAME    TZX"
selectedTitle:	defw	0
selectedPalet:	defw	0
reg9:	defb	0

;***********************************************************
;***********************************************************

parseArguments:	call	fixArguments

	ld	a,(0x80)
	dec	a
	ret	m
	ret	z

	ld	b,a
	ld	hl,0x81
	
1:	ld	a,(hl)
	or	a
	inc	hl
	call	z,compare
	djnz	1b
	ret

;***********************************************************

compare:	ld	ix,arguments

1:	ld	a,(ix)
	or	a
	jp	z,showHelp
	
	push	hl
	
stillOK:	ld	a,(ix)
	cp	(hl)
	jr	nz,next
	or	a
	inc	hl
	inc	ix
	jr	nz,stillOK

	ld	l,(ix+0)
	ld	h,(ix+1)

	push	bc
	call	callHL
	pop	bc

	pop	hl
	ret
	
next:	pop	hl

2:	ld	a,(ix)
	inc	ix
	or	a
	jr	nz,2b
	
	inc	ix
	inc	ix

	jr	1b

;***********************************************************

callHL:	push	hl
	ret

;***********************************************************

fixArguments:	ld	hl,0x81

fixLoop:	ld	a,(hl)
	or	a
	ret	z

	cp	'a'
	jr	c,noCaseFix
	cp	'z'+1
	jr	nc,noCaseFix
	sub	0x20

noCaseFix:	cp	' '
	jr	z,replaceWith0
	cp	0x0D
	jr	nz,1f
replaceWith0:	xor	a
1:	ld	(hl),a
	inc	hl

	jr	fixLoop
	
;***********************************************************
;***********************************************************

setSpectrumTitle:	ld	hl,titleFileNameSpectrum
	jr	1f

;***********************************************************

setMSX1Title:	ld	hl,titleFileNameMSX1
	jr	1f

;***********************************************************

setMSX2Title:	ld	hl,titleFileNameMSX2
	jr	1f

;***********************************************************

setAmigaTitle:	ld	hl,titleFileNameAmiga
1:	ld	(selectedTitle),hl
	ret

;***********************************************************
;***********************************************************

setCoolColorsPalet:	ld	hl,paletteCoolColors
	jr	1f

;***********************************************************

setMSX1Palet:	ld	hl,paletteMSX1
1:	ld	(selectedPalet),hl
	ret

;***********************************************************
;***********************************************************

showHelp:	ld	de,helpMessage
	ld	c,9
	call	MSXDOS
	jp	0

;***********************************************************
;***********************************************************

set60Hz:	ld	a,(reg9)
	and	11111101B
	jr	1f

;***********************************************************

set50Hz:	ld	a,(reg9)
	or	00000010B
1:	ld	(reg9),a
	ret

;***********************************************************
;***********************************************************

loadScenario:	di
	
	ld	(saveorload),a

	; Remove "The startdrive" scenario patch causing units to move through obstacles in other scenarios
	ld	a,0x30
	ld	(0x6F65),a
	ld	hl,0x77A7
	ld	(0x6F66),hl

	ld	a,b
	ld	(blockID),a
	sub	0x63-'0'
	ld	(scenarioFileName+5),a

	call	swap
	ld	(stackSave),sp

	ld	sp,0
DOSStack	equ	$-2	

	ld	a,(KEYINT)
	push	af

	ld	a,ret
	ld	(KEYINT),a
	
	ld	hl,scenarioFileName
	
	ld	a,(saveorload)
	or	a
	jr	nz,load
	
;***********************************************************

save:	scf
	call	fopen

	ld	de,TZXHeader
	ld	hl,TZXHeaderSize
	call	fwrite

	ld	de,scenarioLoadingAddress
	ld	hl,swapAreaStart-scenarioLoadingAddress
	call	fwrite

	ld	de,buffer
	ld	hl,0xFFFF - swapAreaStart
	call	fwrite
	jr	doneOK

;***********************************************************
	
load:	or	a
	call	fopen
	or	a
	jr	nz,doneError

	ld	hl,TZXHeaderSize
	call	fseek

	ld	de,scenarioLoadingAddress
	ld	hl,swapAreaStart-scenarioLoadingAddress
	call	fread

	ld	de,buffer
	ld	hl,0xFFFF - swapAreaStart
	call	fread

doneOK:	call	fclose
	xor	a

doneError:	ld	(0xB0C1),a

	call	stopDisk

	pop	af
	ld	(KEYINT),a

	ld	sp,(stackSave)
	call	swap

	ld	a,(blockID)
	cp	0x63+6
	jr	z,doPatch
	cp	0x63+7
	jr	z,doPatch
	
	ei
	ret

;***********************************************************

doPatch:	ld	de,scenarioLoadingAddress
	call	patchScenario

	ei
	ret

;***********************************************************

scenarioFileName:	defb	0,"MAP01   TZX"
stackSave:	defw	0
saveorload:	defb	0

;***********************************************************
;***********************************************************

swap:	ld	de,buffer
	ld	hl,swapAreaStart
	
1:	ld	a,(de)
	ld	b,(hl)
	
	ld	(hl),a
	ld	a,b
	ld	(de),a
	
	inc	hl
	inc	de
	
	ld	a,h
	inc	a
	jr	nz,1b
	
	ld	a,l
	inc	a
	jr	nz,1b
	ret

;***********************************************************
;***********************************************************
; HL: Drive and file name

fopen:	ld	de,FCB
	ld	bc,12
	ldir
	
	ld	h,d
	ld	l,e
	ld	(hl),0
	inc	de
	ld	bc,24
	ldir
	
	ld	c,0x0F
	jr	nc,1f
	ld	c,0x16
1:	ld	de,FCB
	call	MSXDOS
	ld	hl,1
	ld	(FCB + FCB_RECSIZ),hl
	ret
	
;***********************************************************
;***********************************************************

fclose:	ld	c,0x10
	ld	de,FCB
	jp	MSXDOS

;***********************************************************
;***********************************************************
; HL: Absolute position in file

fseek:	ld	(FCB + FCB_RN),hl
	ret
	
;***********************************************************
;***********************************************************
; DE: Destination address in RAM
; HL: Bytes to read

fread:	push	hl
	ld	c,0x1A
	call	MSXDOS
	pop	hl
	
	ld	de,FCB
	ld	c,0x27
	jp	MSXDOS

;***********************************************************
;***********************************************************
; DE: Source address in RAM
; HL: Bytes to write

fwrite:	push	hl
	ld	c,0x1A
	call	MSXDOS
	pop	hl
	
	ld	de,FCB
	ld	c,0x26
	jp	MSXDOS

;***********************************************************
;***********************************************************

title:	xor	a
	ld	(BDRCLR),a
	ld	(BAKCLR),a

	ld	a,(hl)
	inc	hl

	call	screen

	or	a
	call	fopen
	or	a
	ret	nz

	ld	de,packedData
	ld	hl,0xFFFF
	call	fread

	call	fclose

	ld	ix,DISSCR
	call	callBIOS

	di
	call	setVRAM0

	ld	hl,packedData

1:	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	a,e
	or	d
	jr	z,2f

	push	de
	ld	de,buffer
	call	depack
	pop	de
		
	push	hl
	ld	hl,buffer
	call	copyToVM
	pop	hl
	jr	1b

2:	ld	ix,ENASCR
	jp	callBIOS


;***********************************************************
;***********************************************************

screen:	; Only screen modes 0,1 and 2 on MSX1
	cp	3
	jp	c,1f

	push	af
	call	isMSX1
	jp	z,showHelp
	pop	af

1:	push	hl
	ld	ix,CHGMOD
	call	callBIOS
	pop	hl
	ret

;***********************************************************
;***********************************************************

setPalet:	call	isMSX1
	jp	z,showHelp

	ld	a,00101010B
	out	(VDPPORT1),a
	ld	a,8 + 0x80
	out	(VDPPORT1),a

	ld	b,32
	xor	a
	ld	c,VDPPORT1
	out	(c),a
	ld	a,0x80+0x10
	out	(c),a
	inc	c
	otir
	ret

;***********************************************************
;***********************************************************

callBIOS:	ld	iy,(EXPTBL-1)
	jp	CALSLT

;***********************************************************
;***********************************************************

setVRAM0:	call	isMSX1
	jr	z,1f

	xor	a
	out	(VDPPORT1),a
	ld	a,8Eh
	out	(VDPPORT1),a

1:	xor	a
	out	(VDPPORT1),a
	ld	a,0x40
	out	(VDPPORT1),a
	ret

;***********************************************************
;***********************************************************
; HL: source
; DE: size

copyToVM:	call	isMSX1
	jr	nz,copyToVMMSX2

;***********************************************************

copyToVMMSX1:	ld	c,VDPPORT0
	inc 	e
	dec	e
	jr	z, 2f
	ld	b,e
l1:	outi
	jr	nz,l1
	
	
2:	inc	d
	dec	d
	ret	z
3:	ld	b,0
l2:	outi
	jr	nz,l2
	dec	d
	jr	nz,3b
	ret

;***********************************************************

copyToVMMSX2:	ld	c,VDPPORT0
	inc 	e
	dec	e
	jr	z,2f
	ld	b,e
	otir
	
2:	inc	d
	dec	d
	ret	z
3:	ld	b,0
	otir
	dec	d
	jr	nz,3b
	ret

;***********************************************************
;***********************************************************

stopDisk:	ld	b,0
1:	push	bc
	call	HTIMI
	pop	bc
	djnz	1b
	ret

;***********************************************************
;***********************************************************

waitForKey:	ld	a,8
	ld	ix,SNSMAT
	call	callBIOS
	bit	0,a
	ret	z
	
	ld	a,1
	ld	ix,GTTRIG
	call	callBIOS
	or	a
	ret	nz
	jr	waitForKey

;***********************************************************
;***********************************************************
; Z flag set if MSX 1

isMSX1:	push	hl
	push	de
	ld	hl,MSXVER
	ld	a,(EXPTBL)
	call	RDSLT
	or	a
	pop	de
	pop	hl
	ret

;***********************************************************
;***********************************************************

applyPatch:	ld	e,(hl)
	inc	hl
	
	ld	d,(hl)
	inc	hl
	
	ld	a,e
	or	d
	ret	z
	
	ld	a,(hl)
	inc	hl
	ld	(de),a
	jr	applyPatch

;***********************************************************

PATCHB	MACRO address,byte
	defw	address
	defb	byte
	ENDM

;***********************************************************

PATCHW	MACRO address,word
	defw	address
	defb	.LOW. word
	defw	address+1
	defb	.HIGH. word
	ENDM

;***********************************************************

gamePatch:	; Patch scenario loading function
	PATCHB	0xB0C2,jp
	PATCHW	0xB0C3,loadScenario

	; Patch keyboard routine to support keys 1 to 8
	PATCHB	0xB126,8
	PATCHW	0xA260,keyboard

	; Change scenario selection screen text Y positions
	PATCHB	0xA9DC,1
	PATCHB	0xA9E0,1
	PATCHB	0xA9E8,1
	PATCHB	0xA9EC,1
	PATCHB	0xABAE,5
	PATCHB	0xABB3,8

	; Hook code to display new scenario selection text
	PATCHB	0x658E,call
	PATCHW	0x658F,scenarioMessageHook

	; Save scenario is now #8
	PATCHB	0xB142,8
	PATCHB	0xB178,0x63+8

	; Use cursor keys instead of Q,A,O,P
	PATCHB	0x45BA,0x45
	PATCHB	0x45C3,0x46
	PATCHB	0x45CC,0x44
	PATCHB	0x45D5,0x47
	
	; Fixed display bugs in status bars and "PRESS FIRE TO END SELECTION" message
	PATCHB	0x8759,0x00
	PATCHB	0x87AC,0x0D
	PATCHB	0x8828,0x78
	PATCHB	0x9D41,0x05
	PATCHB	0x9D68,0x00
	PATCHB	0x9E5B,0x00
	PATCHB	0x9F28,0x40
	PATCHB	0x9F2F,0x0A
	PATCHB	0xA075,0x0A
	PATCHB	0xA087,0x0D
	PATCHB	0xA8FC,0x00
	PATCHB	0xA925,0x00
	PATCHB	0xA931,0x05
	PATCHB	0xA936,0x04
	PATCHB	0xA93B,0x00
	PATCHB	0xA946,0x06
	PATCHB	0xA94B,0x05
	PATCHB	0xAA37,0x00
	PATCHB	0xAA4C,0x00
	PATCHB	0xAA81,0x00

	; Remove OUT (0xFE),a causing crash on MSX with memory mapper
	PATCHW	0xB10B,0x0000

	defw	0

;***********************************************************

keyboard:	db	1,2,3,4,5,6,7,8,0x47

;***********************************************************

scenarioMessageHook:	cp	0xA7
	ld	hl,(0x5D07)
	ret	nz
	
	pop	hl
	ld	hl,newMessage
	jp	0x659B

;***********************************************************

newMessage:	defb	"|"
	defb	"1: THE ASSASSINS/"
	defb	"2: MOONBASE ASSAULT/"
	defb	"3: RESCUE FROM THE MINES/"
	defb	"4: THE CYBER HORDES/"
	defb	"5: PARADISE VALLEY/"
	defb	"6: THE STARDRIVE/"
	defb	"7: LASER PLATOON/"
	defb	"8: SAVED GAME/"
	defb	"|"

;***********************************************************
;***********************************************************

patchScenario:	ld	a,(de)
	cp	0x11
	jr	z,tryToPatch
	cp	0x21
	jr	z,tryToPatch
	cp	0x22
	jr	z,tryToPatch
	cp	0x2A
	jr	z,tryToPatch
	cp	0x32
	jr	z,tryToPatch
	cp	0x53
	jr	z,tryToPatch
	cp	0x5B
	jr	z,tryToPatch
	cp	0xC2
	jr	z,tryToPatch
	cp	0xC3
	jr	z,tryToPatch
	cp	0xCD
	jr	z,tryToPatch
	cp	0xD2
	jr	z,tryToPatch
	cp	0xDA
	jr	z,tryToPatch

nextByte:	inc	de
	ld	a,d
	inc	a
	jr	nz,patchScenario
	ld	a,e
	inc	a
	jr	nz,patchScenario
	ret

tryToPatch:	ld	hl,patches
	ld	bc,4

nextPatch:	ld	a,(hl)
	or	a
	jr	z,nextByte

	ld	a,(de)
	cp	(hl)
	jr	z,found1
	add	hl,bc
	inc	hl
	jr	nextPatch

found1:	inc	hl
	inc	de
	ld	a,(de)
	cp	(hl)
	jr	z,found2
	add	hl,bc
	dec	de
	jr	nextPatch

found2:	inc	hl
	inc	de
	ld	a,(de)
	cp	(hl)
	jr	z,found3
	add	hl,bc
	dec	hl
	dec	de
	dec	de
	jr	nextPatch

found3:	inc	hl
	dec	de
	ld	bc,2
	ldir
	jr	patchScenario
	
;***********************************************************

patches:	defb	0x11, 0x60, 0x6F, 0x65, 0x6F
	defb	0x21, 0xCA, 0xA5, 0x92, 0xA5
	defb	0x22, 0x4B, 0xA5, 0x13, 0xA5
	defb	0x22, 0x78, 0xA5, 0x40, 0xA5
	defb	0x22, 0x91, 0x70, 0x96, 0x70
	defb	0x22, 0x93, 0x70, 0x98, 0x70
	defb	0x22, 0xDC, 0xA5, 0xA4, 0xA5
	defb	0x22, 0xDE, 0xA5, 0xA6, 0xA5
	defb	0x2A, 0xDC, 0xA5, 0xA4, 0xA5
	defb	0x2A, 0xDE, 0xA5, 0xA6, 0xA5
	defb	0x32, 0x4B, 0xA5, 0x13, 0xA5
	defb	0x53, 0x4D, 0xA5, 0x15, 0xA5
	defb	0x53, 0xDA, 0xA5, 0xA2, 0xA5
	defb	0x5B, 0x4D, 0xA5, 0x15, 0xA5
	defb	0xC2, 0x42, 0x70, 0x47, 0x70
	defb	0xC3, 0x8C, 0x6F, 0x91, 0x6F
	defb	0xC3, 0xA4, 0xA4, 0x6C, 0xA4
	defb	0xC3, 0xD9, 0xA4, 0xA1, 0xA4
	defb	0xC3, 0xF4, 0x8E, 0xB1, 0x8E
	defb	0xCD, 0x01, 0x72, 0x06, 0x72
	defb	0xCD, 0x01, 0x9D, 0xCA, 0x9C
	defb	0xCD, 0x05, 0x72, 0x0A, 0x72
	defb	0xCD, 0x09, 0x72, 0x0E, 0x72
	defb	0xCD, 0x0B, 0x7F, 0x11, 0x7F
	defb	0xCD, 0x0B, 0x83, 0x11, 0x83
	defb	0xCD, 0x10, 0x6A, 0x14, 0x6A
	defb	0xCD, 0x10, 0x6E, 0x15, 0x6E
	defb	0xCD, 0x12, 0x61, 0x5C, 0x61
	defb	0xCD, 0x16, 0x9A, 0xDF, 0x99
	defb	0xCD, 0x19, 0x6B, 0x1E, 0x6B
	defb	0xCD, 0x22, 0x74, 0x27, 0x74
	defb	0xCD, 0x26, 0x73, 0x2B, 0x73
	defb	0xCD, 0x2A, 0x61, 0x74, 0x61
	defb	0xCD, 0x2A, 0x6C, 0x2F, 0x6C
	defb	0xCD, 0x3A, 0xA5, 0x02, 0xA5
	defb	0xCD, 0x47, 0x77, 0x4C, 0x77
	defb	0xCD, 0x4A, 0x6B, 0x4F, 0x6B
	defb	0xCD, 0x4E, 0x6D, 0x53, 0x6D
	defb	0xCD, 0x50, 0xA5, 0x18, 0xA5
	defb	0xCD, 0x5D, 0x78, 0x62, 0x78
	defb	0xCD, 0x5E, 0x67, 0x48, 0x67
	defb	0xCD, 0x6A, 0x72, 0x6F, 0x72
	defb	0xCD, 0x74, 0x6E, 0x79, 0x6E
	defb	0xCD, 0x79, 0x8F, 0x3C, 0x8F
	defb	0xCD, 0x7A, 0xA5, 0x42, 0xA5
	defb	0xCD, 0x7D, 0x8C, 0x3A, 0x8C
	defb	0xCD, 0x7F, 0x8D, 0x3C, 0x8D
	defb	0xCD, 0x85, 0x67, 0x6F, 0x67
	defb	0xCD, 0x85, 0x8F, 0x48, 0x8F
	defb	0xCD, 0x89, 0x6F, 0x8E, 0x6F
	defb	0xCD, 0x8B, 0x68, 0x75, 0x68
	defb	0xCD, 0x8B, 0x6A, 0x8C, 0x6A
	defb	0xCD, 0x8C, 0x6D, 0x91, 0x6D
	defb	0xCD, 0x8C, 0x6F, 0x91, 0x6F
	defb	0xCD, 0x91, 0x8F, 0x54, 0x8F
	defb	0xCD, 0xA3, 0x68, 0x8D, 0x68
	defb	0xCD, 0xA4, 0xA4, 0x6C, 0xA4
	defb	0xCD, 0xAB, 0x78, 0xB0, 0x78
	defb	0xCD, 0xAF, 0x60, 0xC6, 0x60
	defb	0xCD, 0xAF, 0x6D, 0xB4, 0x6D
	defb	0xCD, 0xB1, 0x80, 0xB7, 0x80
	defb	0xCD, 0xBC, 0x6B, 0xC1, 0x6B
	defb	0xCD, 0xBF, 0x6E, 0xC4, 0x6E
	defb	0xCD, 0xC1, 0x74, 0xC6, 0x74
	defb	0xCD, 0xC2, 0x67, 0xAC, 0x67
	defb	0xCD, 0xCD, 0x69, 0xD1, 0x69
	defb	0xCD, 0xCD, 0x80, 0xD3, 0x80
	defb	0xCD, 0xCF, 0x99, 0x98, 0x99
	defb	0xCD, 0xD7, 0x71, 0xDC, 0x71
	defb	0xCD, 0xDE, 0x6D, 0xE3, 0x6D
	defb	0xCD, 0xDF, 0x67, 0xC9, 0x67
	defb	0xCD, 0xE0, 0xA5, 0xA8, 0xA5
	defb	0xCD, 0xE4, 0x62, 0x2E, 0x63
	defb	0xCD, 0xE9, 0x62, 0x33, 0x63
	defb	0xCD, 0xF4, 0x8E, 0xB1, 0x8E
	defb	0xCD, 0xF7, 0x67, 0xE1, 0x67
	defb	0xCD, 0xF7, 0x79, 0xFC, 0x79
	defb	0xD2, 0x09, 0x6F, 0x0E, 0x6F
	defb	0xDA, 0xF4, 0x8E, 0xB1, 0x8E
	defb	0x00


;******************************************************************************
; macro to get a bit from the bitstream
; carry if bit is set, nocarry if bit is clear
; must be entered with second registerset switched in!
;******************************************************************************

GET_BIT_FROM_BITSTREAM	MACRO
	add	a,a	; shift out new bit
	call	z,read_byte	; if remaining value isn't zero, we're done
	ENDM

;******************************************************************************
;******************************************************************************

read_byte:	ld	a,(hl)	; get 8 bits from bitstream
	inc	hl	; increase source data address
	scf
	rla		; (bit 0 will be set!!!!)
	ret
	
;******************************************************************************
; HL: source
; DE: destination
;******************************************************************************

depack::	ld	a,0x80
	
	exx
	ld	de,1
	exx
	
depack_loop:	GET_BIT_FROM_BITSTREAM		; get compression type bit
	jp	c,output_compressed	; if set, we got lz77 compression
	ldi		; copy byte from compressed data to destination (literal byte)
	GET_BIT_FROM_BITSTREAM		; get compression type bit
	jp	c,output_compressed	; if set, we got lz77 compression
	ldi		; copy byte from compressed data to destination (literal byte)
	GET_BIT_FROM_BITSTREAM		; get compression type bit
	jp	c,output_compressed	; if set, we got lz77 compression
	ldi		; copy byte from compressed data to destination (literal byte)
	jp	depack_loop
	
;******************************************************************************
; handle compressed data
;******************************************************************************

output_compressed:	ld	c,(hl)	; get lowest 7 bits of offset, plus offset extension bit
	inc	hl	; to next byte in compressed data

output_match:	ld	b,0
	bit	7,c
	jr	z,output_match1	; no need to get extra bits if carry not set

	GET_BIT_FROM_BITSTREAM		; get offset bit 10 
	rl	b
	GET_BIT_FROM_BITSTREAM		; get offset bit 9
	rl	b
	GET_BIT_FROM_BITSTREAM		; get offset bit 8
	rl	b
	GET_BIT_FROM_BITSTREAM		; get offset bit 7

	jp	c,output_match1	; since extension mark already makes bit 7 set 
	res	7,c	; only clear it if the bit should be cleared

output_match1:	inc	bc
	
;******************************************************************************
; return a gamma-encoded value
; length returned in HL
;******************************************************************************

	exx		; to second register set!
	ld	h,d
	ld	l,e	; initial length to 1
	ld	b,e	; bitcount to 1

;******************************************************************************
; determine number of bits used to encode value
;******************************************************************************

get_gamma_value_size:	exx
	GET_BIT_FROM_BITSTREAM		; get more bits
	exx
	jr	nc,get_gamma_value_size_end	; if bit not set, bitlength of remaining is known
	inc	b	; increase bitcount
	jp	get_gamma_value_size	; repeat...

get_gamma_value_bits:	exx
	GET_BIT_FROM_BITSTREAM		; get next bit of value from bitstream
	exx
	
	adc	hl,hl	; insert new bit in HL

get_gamma_value_size_end:	djnz	get_gamma_value_bits	; repeat if more bits to go

	inc	hl	; length was stored as length-2 so correct this
	exx		; back to normal register set
	
	ret	c
			; HL' = length
	push	hl	; address compressed data on stack

	exx
	push	hl	; match length on stack
	exx

	ld	h,d
	ld	l,e	; destination address in HL...
	sbc	hl,bc	; calculate source address

	pop	bc	; match length from stack

	ldir		; transfer data

	pop	hl	; address compressed data back from stack

	GET_BIT_FROM_BITSTREAM		; get compression type bit
	jp	c,output_compressed	; if set, we got lz77 compression
	ldi		; copy byte from compressed data to destination (literal byte)
	GET_BIT_FROM_BITSTREAM		; get compression type bit
	jp	c,output_compressed	; if set, we got lz77 compression
	ldi		; copy byte from compressed data to destination (literal byte)

	jp	depack_loop

;***********************************************************
;***********************************************************

TZXHeader:	defb	0x5A, 0x58, 0x54, 0x61, 0x70, 0x65, 0x21, 0x1A, 0x01, 0x0A, 0x30, 0x1C, 0x43, 0x72, 0x65, 0x61
	defb	0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x52, 0x61, 0x6D, 0x73, 0x6F, 0x66, 0x74 
	defb	0x20, 0x4D, 0x61, 0x6B, 0x65, 0x54, 0x5A, 0x58, 0x10, 0xE8, 0x03, 0xDF, 0x49
blockID:	defb	0x00
TZXHeaderSize	equ	$-TZXHeader

FCB:	defs	37


;***********************************************************
;***********************************************************

buffer:
packedData	equ	buffer + 16384

;***********************************************************
;***********************************************************

titleFileNameSpectrum:	defb	2,0,"TITSPECTBBP"
titleFileNameMSX1:	defb	2,0,"TITMSX1 BBP"
titleFileNameMSX2:	defb	8,0,"TITMSX2 BBP"
titleFileNameAmiga:	defb	8,0,"TITAMIGABBP"

;***********************************************************

paletteCoolColors:	defw	0x0000, 0x0000, 0x0523, 0x0634,	0x0215, 0x0326, 0x0251, 0x0537
	defw	0x0362, 0x0472, 0x0672, 0x0774, 0x0412, 0x0254, 0x0555, 0x0777

paletteMSX1:	defw	0x0000, 0x0000, 0x0501, 0x0623, 0x0327, 0x0437, 0x0362, 0x0617
	defw	0x0372, 0x0473, 0x0552, 0x0663, 0x0401, 0x0365, 0x0666, 0x0777

;***********************************************************

arguments:	defb	"/TS",0
	defw	setSpectrumTitle

	defb	"/T1",0
	defw	setMSX1Title

	defb	"/T2",0
	defw	setMSX2Title

	defb	"/TA",0
	defw	setAmigaTitle

	defb	"/PC",0
	defw	setCoolColorsPalet

	defb	"/P1",0
	defw	setMSX1Palet

	defb	"/?",0
	defw	showHelp

	defb	"/H50",0
	defw	set50Hz

	defb	"/H60",0
	defw	set60Hz

	defb	0

;***********************************************************

helpMessage:	defb	13,10
	defb	"Laser Squad disk version 1.2",13,10
	defb	"============================",13,10
	defb	13,10
	defb	"Coded by Louthrax in June 2016",13,10
	defb	"MSX titles GFX by FRS",13,10
	defb	13,10
	defb	"Options:",13,10
	defb	"  /T1  MSX1 title (default on MSX1)",13,10
	defb	"  /TS  Spectrum title",13,10
	defb	"  /?   Show this help",13,10
	defb	13,10
	defb	"MSX2-only options:",13,10
	defb	"  /T2  MSX2 title (default on MSX2)",13,10
	defb	"  /TA  Amiga title",13,10
	defb	"  /PC  CoolColors palette",13,10
	defb	"  /P1  MSX1 palette",13,10
	defb	"  /H50 50Hz display",13,10
	defb	"  /H60 60Hz display",13,10
	defb	"$"
